#!/bin/bash
PRODUCT_NAME="cloudstorage"
PRODUCT_DISPLAY_NAME="Cloud Storage"

SOURCE=$(dirname $0)
INSTALL_DEST=${HOME}/.${PRODUCT_NAME}-dist/

if [[ `id -u` -eq 0 ]]; then
   read -p "Do you really want to install this as root? [y]es or [n]o" -n 1
   echo
   if [[ $REPLY =~ ^[Nn]$ ]]; then
     echo "Exiting"
     exit 1
   fi
fi

#HAS_LIBGTK2=`/sbin/ldconfig -p 2>/dev/null| grep libgtk-x11-2.0.so`
#if [ -z "$HAS_LIBGTK2" ]; then
#    echo "This application requires GTK+ 2 libraries which are not present on your system."
#    if which apt-get 2>&1 >/dev/null; then
#        echo "Install them with:"
#        echo "  sudo apt-get install libgtk2.0"
#    else
#        echo "You should install your distribution's libgtk2.0 package."
#    fi
#    echo "Then run this installer again."
#    exit 1
#fi

echo "Program will be installed to ${INSTALL_DEST}."
read -p "Do you want to change destination? [y]es or [n]o" -n 1
echo

if [[ $REPLY =~ ^[Yy]$ ]]; then
  read -p "Please enter install destination:" -e INSTALL_DEST
  echo
  if [[ -d $INSTALL_DEST ]]; then
    echo "Destination already exists!"
    read -p "Are you sure you want to use this folder? [y]es or [n]o" -n 1
    echo
    if [[ $REPLY =~ ^[Nn]$ ]]; then
      exit 2
    fi
  fi
fi

echo "Installing into $INSTALL_DEST"
mkdir -p ${INSTALL_DEST}
INSTALL_DEST=$(realpath $INSTALL_DEST)
cp -av ${SOURCE}/* ${INSTALL_DEST}

HAS_UDEV0=`ldd ${INSTALL_DEST}/storagechrome | grep "not found" | grep libudev.so.0`
HAS_UDEV1=`/sbin/ldconfig -p | grep libudev.so.1`

if [ -n "$HAS_UDEV0" ]; then
  if [ -n "$HAS_UDEV1" ]; then
    ARCH=`uname -m`
    case $ARCH in
    i[3-6]86)
      udev1=`/sbin/ldconfig -p | grep i[3-6]86 | grep 'libudev.so.1$' | awk '{print $4}'`
      ;;
    x86_64)
      udev1=`/sbin/ldconfig -p | grep x86_64 | grep 'libudev.so.1$' | awk '{print $4}'`
      ;;
    esac
    if [ -z "$udev1" ]; then
      udev1=`echo $HAS_UDEV1 | grep 'libudev.so.1' | awk '{print $4}'`
    fi
    if [ -n "$udev1" ]; then
      echo "Creating symlink from libudev.so.0 to $udev1"
      ln -s $udev1 ${INSTALL_DEST}/libudev.so.0
    else
      echo "Failed to find any libudev on system. Embedded browser will not work."
    fi
  fi
fi

DESKTOP_DEST=${SOURCE}
if [[ -d ${HOME}/.local ]]; then
  DESKTOP_DEST=${HOME}/.local/share/applications
  mkdir -p ${DESKTOP_DEST}
fi

DESKTOP_ENTRY=${DESKTOP_DEST}/${PRODUCT_NAME}.desktop

cat > ${DESKTOP_ENTRY} <<EOF
[Desktop Entry]
  Name=${PRODUCT_DISPLAY_NAME}
  GenericName=Hybrid storage cloud
  Exec=${INSTALL_DEST}/storagegui
  Terminal=false
  Type=Application
  Icon=${INSTALL_DEST}/icon.png
  Categories=Network;FileTransfer;Internet;
EOF

echo "Desktop entry created! $DESKTOP_ENTRY"

AUTOSTART_DESKTOP_DEST=${HOME}/.config/autostart
mkdir -p ${AUTOSTART_DESKTOP_DEST}

AUTOSTART_DESKTOP_ENTRY=${AUTOSTART_DESKTOP_DEST}/${PRODUCT_NAME}.desktop

cp ${DESKTOP_ENTRY} ${AUTOSTART_DESKTOP_ENTRY}

echo "Autostart desktop entry created! $AUTOSTART_DESKTOP_ENTRY"
